#include <stdio.h>
#include <stdint.h>

struct RC4STATE
{
    uint8_t state[256];
    uint8_t i;
    uint8_t j;
};

void ksa(struct RC4STATE* rc4State, uint8_t* key, uint8_t keylength)
{
    rc4State->i = 0;
    rc4State->j = 0;
    //generate identity permutation
    for(uint32_t i = 0; i < 256; i++)
    {
        rc4State->state[i] = i;
    }

    //shuffle "state"
    uint8_t j = 0;
    uint32_t temp = 0;
    for(uint32_t i = 0; i < 256; i++)
    {
        j = (j + rc4State->state[i] + key[i % keylength]);

        //swap state[i] and state[j]
        temp = rc4State->state[i];
        rc4State->state[i] = rc4State->state[j];
        rc4State->state[j] = temp;
    }
}

uint8_t pgra(struct RC4STATE* rc4State)
{
    //this looks like some of my old calculator code
    uint8_t temp;

    rc4State->i++;
    rc4State->j = rc4State->state[rc4State->i] + rc4State->j;

    temp = rc4State->state[rc4State->i];
    rc4State->state[rc4State->i] = rc4State->state[rc4State->j];
    rc4State->state[rc4State->j] = temp;

    return rc4State->state[
        (rc4State->state[rc4State->i] + rc4State->state[rc4State->j])
        % 256
    ];
}


void crypt(uint8_t* text, uint8_t* key, uint64_t textLength, uint8_t keyLength)
{
    struct RC4STATE rc4State;

    ksa(&rc4State, key, keyLength);

    //discard 4096 bytes
    for(uint64_t i = 0; i < 8192; i++) pgra(&rc4State);

    for(uint64_t i = 0; i < textLength; i++)
    {
        text[i] = text[i] ^ pgra(&rc4State);
    }
}


int main()
{
    uint8_t text[] = "hello world i think triad is cool i wish he was he rn\n";
    uint8_t key[] = "432";

    crypt(text, key, sizeof(text)-1, sizeof(key)-1);
    for(uint64_t i = 0; i < sizeof(text)-1; i++) printf("%.2x", text[i]);
    printf("\n");

    crypt(text, key, sizeof(text)-1, sizeof(key)-1);
    for(uint64_t i = 0; i < sizeof(text)-1; i++) printf("%c", text[i]);
    printf("\n");

}